module TV_to_VGA (
			OSC,
			RESET,
 			VGA_BLANK,
			VGA_SYNC,
			VGA_CLOCK,
			VGA_HS,
 			VGA_VS,
			VGA_R,
 			VGA_G,
 			VGA_B,
 			TD_D,
 			TD_HS,
 			TD_VS
);
input		    OSC;
input			RESET;
output 			VGA_BLANK;
output			VGA_SYNC;
output			VGA_CLOCK;
output			VGA_HS;
output 			VGA_VS;
output			[9:0]VGA_R;
output 			[9:0]VGA_G;
output 			[9:0]VGA_B;
input 			[7:0]TD_D;
input 			TD_HS;
input 			TD_VS;


wire [7:0]	Y;       //4:4:4 Y
wire [7:0]	Cb;      //4:4:4 Cb
wire [7:0]	Cr;      //4:4:4 Cr
wire mTD_HSx2;

itu_r656_decoder U1
(
	.CLOCK(OSC_27),		//system clock
	.TD_D(TD_D[7:0]),	//4:2:2 video data stream
 	.TD_HS(TD_HS),		//Decoder_hs 
	.TD_VS(TD_VS),		//Decoder_vs	
	.Y(Y[7:0]),       	//4:4:4 Y
	.Cb(Cb[7:0]),      	//4:4:4 Cb
	.Cr(Cr[7:0]),      	//4:4:4 Cr
    .HSx2(mTD_HSx2),       
	.blank(VGA_BLANK)
);

YCbCr2RGB U2(	
	.Red(VGA_R[9:0]),
	.Green(VGA_G[9:0]),
	.Blue(VGA_B[9:0]),
	.iY(Y[7:0]),
	.iCb(Cb[7:0]),
	.iCr(Cr[7:0]),			
	.iRESET(RESET),	//before: .iRESET(!RESET) 
	.iCLK(OSC_27)
	);

reg 	[10:0]L_COUNTER;//<<
reg 	[10:0]RL_COUNTER;//<<
wire 	sync_reset=(RL_COUNTER==9)?1:0;//<<
reg  	sync_en;//<<
reg  	[7:0]delay;//<<

reg		[9:0]	H_Cont;
reg		[9:0]	V_Cont;
reg				oVGA_H_SYNC;
reg				oVGA_V_SYNC;
reg				Pre_HS;
reg				Pre_VS;
reg				mACT_HS;
reg				mACT_VS;

reg 	OSC_27;

always@(posedge OSC)
begin
	OSC_27 <= ~OSC_27;
end


always@(posedge OSC_27 or negedge sync_en)//<<
begin
	if(!sync_en)//<<
	begin
		Pre_HS		<=	0;
		mACT_HS		<=	0;
		H_Cont		<=	0;
		oVGA_H_SYNC	<=	0;
	end
	else
	begin
		Pre_HS	<=	mTD_HSx2;
		if({Pre_HS,mTD_HSx2}==2'b10)
		mACT_HS	<=	1;
		if(mACT_HS)
		begin
			//	H_Sync Counter
			if( H_Cont < 852 )
			H_Cont	<=	H_Cont+1;
			else
			begin
				H_Cont	<=	0;
				mACT_HS	<=	0;
			end
			//	H_Sync Generator
			if( H_Cont < 96 )
			oVGA_H_SYNC	<=	0;
			else
			oVGA_H_SYNC	<=	1;
		end
		else
		begin
			oVGA_H_SYNC	<=	0;
			H_Cont		<=	0;
		end
	end
end

always@(posedge OSC_27 or negedge sync_en)//<<
begin
	if(!sync_en)//<<
	begin
		Pre_VS		<=	1;
		mACT_VS		<=	0;
		V_Cont		<=	0;
		oVGA_V_SYNC	<=	0;
	end
	else
	begin
		Pre_VS	<=	TD_VS;
		if({Pre_VS,TD_VS}==2'b01)
		mACT_VS	<=	1;
		if( (H_Cont==1) && mACT_VS)
		begin
			//	V_Sync Counter
			if( V_Cont < 524 )
			V_Cont	<=	V_Cont+1;
			else
			V_Cont	<=	0;
			//	V_Sync Generator
			if(	V_Cont < 2 )
			oVGA_V_SYNC	<=	0;
			else
			oVGA_V_SYNC	<=	1;
		end
	end
end

assign	VGA_HS		=	oVGA_H_SYNC;
assign	VGA_VS		=	oVGA_V_SYNC;
assign	VGA_SYNC	=	1'b0;
assign	VGA_CLOCK	=	OSC_27;


//>>lock detector
always @(posedge TD_HS) begin
if (TD_VS) L_COUNTER=0;		  
			else L_COUNTER=L_COUNTER+1;
end			

always @(posedge TD_VS) begin
		RL_COUNTER=L_COUNTER;//1714
end	
always@(negedge sync_reset or posedge TD_VS) begin
if (!sync_reset)
	delay=0;
    else if (delay < 250)
	 delay=delay+1;
end	

always@(negedge sync_reset or negedge TD_VS) begin
if (!sync_reset)     
		sync_en=0; 
else if (delay < 100)
    sync_en=0; 
    else
	sync_en=1;
end
//<<

endmodule